--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--
rollout DYNfileSelector "" width:561 height:419
(
  local LOCcurrentFile
  local LOCpopupMenu1
  local LOCpopupMenu2
  local LOCfileDir         = ""
  local LOClongFileType    = ""
  local LOCresourceKitMode = 1

  fn DYNFUNresizeFileSelectorPanel FUNnewSize =
  (
    local rollout_dnLvMin = [98,134]

    if FUNnewSize.y < 419 then (FUNnewSize.y = 419; DYNfileSelector.height = 419)
    if FUNnewSize.x < 561 then (FUNnewSize.x = 561; DYNfileSelector.width  = 561)

    DYNfileSelector.dnFileList.width    = (FUNnewSize - rollout_dnLvMin).x
    DYNfileSelector.dnFileList.height   = (FUNnewSize - rollout_dnLvMin).y
    DYNdefRLsizeFSE                     = FUNnewSize
    DYNfileSelector.BUDYNokok.pos       = FUNnewSize - [88,89]
    DYNfileSelector.BUDYNcanc.pos       = FUNnewSize - [88,65]
    DYNfileSelector.BUDYNhelp.pos       = FUNnewSize - [88,41]
    DYNfileSelector.BUDYNdetails.pos.x  = FUNnewSize.x - 118
    DYNfileSelector.BUDYNimport.pos.x   = FUNnewSize.x - 88
    DYNfileSelector.EDDYNfilePath.width = FUNnewSize.x - 215
    DYNfileSelector.EDDYNfilename.width = FUNnewSize.x - 317
    DYNfileSelector.DDDYNfileType.width = FUNnewSize.x - 315
    DYNfileSelector.LBDYNfileName.pos.y = FUNnewSize.y - 87
    DYNfileSelector.EDDYNfileName.pos.y = FUNnewSize.y - 90
    DYNfileSelector.LBDYNfileType.pos.y = FUNnewSize.y - 61
    DYNfileSelector.DDDYNfileType.pos.y = FUNnewSize.y - 64
  )

  fn DYNFUNsaveOrOpenSelectedFile FUNfile =
  (
    if DYNfileSelectorSaveMode then
    (
      local LOCsaveSwitch = if DoesFileExist FUNfile then queryBox (FUNfile + "\n\n" + DYNuiResourcesErrorsWarnings[36]) title:DYNuiResourcesTitlebars[23] else true
      if LOCsaveSwitch then
      (
        DYNfileSelector.LOCcurrentFile = FUNfile
        destroyDialog DYNfileSelector
      )
    )
    else
    (
      if not (DoesFileExist FUNfile) then
      (
        messagebox ((filenamefrompath FUNfile) + "\n\n" + DYNuiResourcesErrorsWarnings[37]) title:DYNuiResourcesTitlebars[24]
      )
      else
      (
        DYNfileSelector.LOCcurrentFile = FUNfile
        destroyDialog DYNfileSelector
      )
    )
  )

  fn DYNFUNpopulateFileName FUNfileName =
  (
    DYNfileSelector.EDDYNfilename.text = FilenameFromPath FUNfileName
    if DYNfileSelector.dnFileList.items.count > 0 then
    (
      if (DYNfileSelector.dnFileList.findItemWithText DYNfileSelector.EDDYNfilename.text false 0) != undefined then
      (
        (DYNfileSelector.dnFileList.findItemWithText DYNfileSelector.EDDYNfilename.text false 0).selected = true
      )
    )
  )

  fn DYNFUNsetFilePanelMode FUNcountryKitPath FUNfileType FUNsaveMode =
  (
    --- Set Name of Sub-Folder we are looking at
    if FUNfileType == "RMS" then (DYNfileSelector.LOClongFileType = DYNstringRMSfolderName)
    if FUNfileType == "FIS" then (DYNfileSelector.LOClongFileType = DYNstringFISfolderName)
    if FUNfileType == "ROS" then (DYNfileSelector.LOClongFileType = DYNstringROSfolderName)
    if FUNfileType == "OPS" then (DYNfileSelector.LOClongFileType = DYNstringOPSfolderName)
    if FUNfileType == "SOS" then (DYNfileSelector.LOClongFileType = DYNstringSOSfolderName)
    if FUNfileType == "BOS" then (DYNfileSelector.LOClongFileType = DYNstringBOSfolderName)

    --- UPdate Contents of File List View
    DYNfileSelector.dnFileList.Items.clear()
    local LOCfileList = getFiles (FUNcountryKitPath + "\\" + DYNfileSelector.LOClongFileType + "\\*" + (DYNFUNlowerCase DYNfileSelectorFileType))
    local LOClistItemRange = #()
    for i in LOCfileList do
    (
      local LOClistItem      = dotNetObject "System.Windows.Forms.ListViewItem" (filenamefrompath i)
      LOClistItem.imageIndex = 0
      LOClistItem.tag        = i
      LOClistItem.SubItems.add (((DYNFUNfileSize i) as string) + " KB")
      LOClistItem.SubItems.add ((DYNFUNupperCase (subString (getfilenametype i) 2 -1) 0) + " " + DYNuiResourcesLvColumns[51])
      LOClistItem.SubItems.add (DYNFUNconvertGUPdate (DYNFUNgetFileModifyTime i true))
      append LOClistItemRange LOClistItem
    )
    DYNfileSelector.dnFileList.Items.AddRange LOClistItemRange

    --- Update Rest Of Panel
    DYNfileSelector.LOCfileDir          = FUNcountryKitPath + "\\" + DYNfileSelector.LOClongFileType + "\\"
    DYNfileSelector.title               = if FUNsaveMode then DYNuiResourcesTitlebars[26] else DYNuiResourcesTitlebars[25]
    DYNfileSelector.BUDYNokok.text      = if FUNsaveMode then DYNuiResourcesButtons[8]    else DYNuiResourcesButtons[6]
    DYNfileSelector.DDDYNfileType.items = #(DYNfileSelector.LOClongFileType + " (*." + (DYNFUNlowerCase FUNfileType) + ")")
    DYNfileSelector.EDDYNfilePath.text  = DYNfileSelector.LOCfileDir
    DYNfileSelector.BUDYNimport.enabled = not FUNsaveMode
    setFocus DYNfileSelector.EDDYNfileName
  )

  fn DYNFUNlistMode FUNlistModeInt =
  (
    /*
      .Details : <System.Windows.Forms.View>, read-only, static
      .LargeIcon : <System.Windows.Forms.View>, read-only, static
      .List : <System.Windows.Forms.View>, read-only, static
      .SmallIcon : <System.Windows.Forms.View>, read-only, static
      .Tile : <System.Windows.Forms.View>, read-only, static
    */
    if FUNlistModeInt == 1 then (DYNfileSelector.dnFileList.view = DYNdnViewClass.largeIcon)
    if FUNlistModeInt == 2 then (DYNfileSelector.dnFileList.view = DYNdnViewClass.SmallIcon)
    if FUNlistModeInt == 3 then (DYNfileSelector.dnFileList.view = DYNdnViewClass.list)
    if FUNlistModeInt == 4 then (DYNfileSelector.dnFileList.view = DYNdnViewClass.Details)

    DYNfileSelectorViewType = FUNlistModeInt
  )

  fn DYNFUNmakePopupMenu1 =
  (
    DYNfileSelector.LOCpopupMenu1 = undefined
    rcmenu LOCpopupMenu1
    (
      menuItem  MNDYNlistType1 checked:false
      menuItem  MNDYNlistType2 checked:false
      menuItem  MNDYNlistType3 checked:false
      menuItem  MNDYNlistType4 checked:false

      on LOCpopupMenu1 open do
      (
        MNDYNlistType1.text    = DYNuiResourcesMenus[41]
        MNDYNlistType2.text    = DYNuiResourcesMenus[42]
        MNDYNlistType3.text    = DYNuiResourcesMenus[43]
        MNDYNlistType4.text    = DYNuiResourcesMenus[44]
        MNDYNlistType1.checked = DYNfileSelector.dnFileList.view == DYNdnViewClass.largeIcon
        MNDYNlistType2.checked = DYNfileSelector.dnFileList.view == DYNdnViewClass.SmallIcon
        MNDYNlistType3.checked = DYNfileSelector.dnFileList.view == DYNdnViewClass.list
        MNDYNlistType4.checked = DYNfileSelector.dnFileList.view == DYNdnViewClass.Details
      )

      on LOCpopupMenu1 close do
      (
      )

      on MNDYNlistType1 picked do DYNfileSelector.DYNFUNlistMode 1
      on MNDYNlistType2 picked do DYNfileSelector.DYNFUNlistMode 2
      on MNDYNlistType3 picked do DYNfileSelector.DYNFUNlistMode 3
      on MNDYNlistType4 picked do DYNfileSelector.DYNFUNlistMode 4
    )
    registerRightClickMenu DYNfileSelector.LOCpopupMenu1
  )

  fn DYNFUNmakePopupMenu2 =
  (
    DYNfileSelector.LOCpopupMenu2 = undefined

    local LOCexe = "rcmenu LOCpopupMenu2\n"
    LOCexe += "(\n"
    LOCexe += "  local LOCselectedFile = \"\"\n"
    LOCexe += "\n"
    LOCexe += "  menuItem  MNDYNopen checked:false\n"
    LOCexe += "  menuItem  MNDYNedit checked:false\n"
    LOCexe += "  separator MNDYNseparator1\n"
    LOCexe += "  subMenu \"" + DYNuiResourcesSubMenus[9] + "\"\n"
    LOCexe += "  (\n"
    LOCexe += "    menuItem  MNDYNcopyToCountry checked:false enabled:false\n"
    LOCexe += "    menuItem  MNDYNcopyToProject checked:false enabled:false\n"
    LOCexe += "    menuItem  MNDYNcopyToPrivate checked:false enabled:false\n"
    LOCexe += "  )\n"
    LOCexe += "  subMenu \"" + DYNuiResourcesSubMenus[8] + "\"\n"
    LOCexe += "  (\n"
    LOCexe += "    menuItem  MNDYNmoveToCountry checked:false enabled:false\n"
    LOCexe += "    menuItem  MNDYNmoveToProject checked:false enabled:false\n"
    LOCexe += "    menuItem  MNDYNmoveToPrivate checked:false enabled:false\n"
    LOCexe += "  )\n"
    LOCexe += "  separator MNDYNseparator2\n"
    LOCexe += "  menuItem  MNDYNcopy    checked:false\n"
    LOCexe += "  separator MNDYNseparate0\n"
    LOCexe += "  menuItem  MNDYNdelete  checked:false\n"
    LOCexe += "  menuItem  MNDYNrename  checked:false\n"
    LOCexe += "  separator MNDYNseparator3\n"
    LOCexe += "  menuItem  MNDYNrefresh checked:false\n"
    LOCexe += "  separator MNDYNseparator4\n"
    LOCexe += "  menuItem  MNDYNprops   checked:false enabled:false\n"
    LOCexe += "\n"
    LOCexe += "  on LOCpopupMenu2 open do\n"
    LOCexe += "  (\n"
    LOCexe += "    MNDYNopen.text          = DYNuiResourcesMenus[45]\n"
    LOCexe += "    MNDYNedit.text          = DYNuiResourcesMenus[46]\n"
    LOCexe += "    MNDYNcopyToCountry.text = DYNuiResourcesMenus[47]\n"
    LOCexe += "    MNDYNcopyToProject.text = DYNuiResourcesMenus[48]\n"
    LOCexe += "    MNDYNcopyToPrivate.text = DYNuiResourcesMenus[49]\n"
    LOCexe += "    MNDYNmoveToCountry.text = DYNuiResourcesMenus[47]\n"
    LOCexe += "    MNDYNmoveToProject.text = DYNuiResourcesMenus[48]\n"
    LOCexe += "    MNDYNmoveToPrivate.text = DYNuiResourcesMenus[49]\n"
    LOCexe += "    MNDYNcopy.text          = DYNuiResourcesMenus[34]\n"
    LOCexe += "    MNDYNdelete.text        = DYNuiResourcesMenus[10]\n"
    LOCexe += "    MNDYNrename.text        = DYNuiResourcesMenus[7]\n"
    LOCexe += "    MNDYNrefresh.text       = DYNuiResourcesMenus[2]\n"
    LOCexe += "    MNDYNprops.text         = DYNuiResourcesMenus[8]\n"
    LOCexe += "\n"
    LOCexe += "    LOCselectedFile   = DYNfileSelector.LOCfileDir + DYNfileSelector.dnFileList.selectedItems.item[0].text\n"
    LOCexe += "    MNDYNopen.enabled = not DYNfileSelectorSaveMode\n"
    LOCexe += "\n"
    LOCexe += "    local LOCcountryKitItemsEnabled = DYNfileSelector.LOCresourceKitMode != 1\n"
    LOCexe += "    local LOCprojectKitItemsEnabled = DYNfileSelector.LOCresourceKitMode != 2 and DYNINIprojectKit != \"0\" and (DYNFUNdoesFolderExist (rootNode.DYNrootNodeStore.string02 + LOClongFileType))\n"
    LOCexe += "    local LOCprivateKitItemsEnabled = DYNfileSelector.LOCresourceKitMode != 3 and DYNINIprivateKit == \"1\" and (DYNFUNdoesFolderExist (DYNINIprivateKitPath + LOClongFileType))\n"
    LOCexe += "    MNDYNmoveToCountry.enabled = LOCcountryKitItemsEnabled\n"
    LOCexe += "    MNDYNcopyToCountry.enabled = LOCcountryKitItemsEnabled\n"
    LOCexe += "    MNDYNmoveToProject.enabled = LOCprojectKitItemsEnabled\n"
    LOCexe += "    MNDYNcopyToProject.enabled = LOCprojectKitItemsEnabled\n"
    LOCexe += "    MNDYNmoveToPrivate.enabled = LOCprivateKitItemsEnabled\n"
    LOCexe += "    MNDYNcopyToPrivate.enabled = LOCprivateKitItemsEnabled\n"
    LOCexe += "  )\n"
    LOCexe += "\n"
    LOCexe += "  on LOCpopupMenu2 close do\n"
    LOCexe += "  (\n"
    LOCexe += "  )\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNopen    picked do\n"
    LOCexe += "  (\n"
    LOCexe += "    DYNfileSelector.DYNFUNsaveOrOpenSelectedFile LOCselectedFile\n"
    LOCexe += "  )\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNmoveToCountry picked do\n"
    LOCexe += "  (\n"
    LOCexe += "    local LOCsuccess = DYNFUNrenameFile LOCselectedFile (DYNcountryPath + DYNfileSelector.LOClongFileType + DYNfolderSeperator + (FilenameFromPath LOCselectedFile)) DYNfileSelectorFileType true\n"
    LOCexe += "    if LOCsuccess then DYNfileSelector.DYNFUNsetFilePanelMode DYNfileSelector.dnResourceKitList.selectedItems.item[0].tag DYNfileSelectorFileType DYNfileSelectorSaveMode\n"
    LOCexe += "  )\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNcopyToCountry picked do\n"
    LOCexe += "  (\n"
    LOCexe += "    local LOCsuccess = DYNFUNcopyFile LOCselectedFile (DYNcountryPath + DYNfileSelector.LOClongFileType + DYNfolderSeperator + (FilenameFromPath LOCselectedFile)) DYNfileSelectorFileType true\n"
    LOCexe += "    if LOCsuccess then DYNfileSelector.DYNFUNsetFilePanelMode DYNfileSelector.dnResourceKitList.selectedItems.item[0].tag DYNfileSelectorFileType DYNfileSelectorSaveMode\n"
    LOCexe += "  )\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNmoveToProject picked do\n"
    LOCexe += "  (\n"
    LOCexe += "    local LOCsuccess = DYNFUNrenameFile LOCselectedFile (rootNode.DYNrootNodeStore.string02 + DYNfileSelector.LOClongFileType + DYNfolderSeperator + (FilenameFromPath LOCselectedFile)) DYNfileSelectorFileType true\n"
    LOCexe += "    if LOCsuccess then DYNfileSelector.DYNFUNsetFilePanelMode DYNfileSelector.dnResourceKitList.selectedItems.item[0].tag DYNfileSelectorFileType DYNfileSelectorSaveMode\n"
    LOCexe += "  )\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNcopyToProject picked do\n"
    LOCexe += "  (\n"
    LOCexe += "    local LOCsuccess = DYNFUNcopyFile LOCselectedFile (rootNode.DYNrootNodeStore.string02 + DYNfileSelector.LOClongFileType + DYNfolderSeperator + (FilenameFromPath LOCselectedFile)) DYNfileSelectorFileType true\n"
    LOCexe += "    if LOCsuccess then DYNfileSelector.DYNFUNsetFilePanelMode DYNfileSelector.dnResourceKitList.selectedItems.item[0].tag DYNfileSelectorFileType DYNfileSelectorSaveMode\n"
    LOCexe += "  )\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNmoveToPrivate picked do\n"
    LOCexe += "  (\n"
    LOCexe += "    local LOCsuccess = DYNFUNrenameFile LOCselectedFile (DYNINIprivateKitPath + DYNfileSelector.LOClongFileType + DYNfolderSeperator + (FilenameFromPath LOCselectedFile)) DYNfileSelectorFileType true\n"
    LOCexe += "    if LOCsuccess then DYNfileSelector.DYNFUNsetFilePanelMode DYNfileSelector.dnResourceKitList.selectedItems.item[0].tag DYNfileSelectorFileType DYNfileSelectorSaveMode\n"
    LOCexe += "  )\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNcopyToPrivate picked do\n"
    LOCexe += "  (\n"
    LOCexe += "    local LOCsuccess = DYNFUNcopyFile LOCselectedFile (DYNINIprivateKitPath + DYNfileSelector.LOClongFileType + DYNfolderSeperator + (FilenameFromPath LOCselectedFile)) DYNfileSelectorFileType true\n"
    LOCexe += "    if LOCsuccess then DYNfileSelector.DYNFUNsetFilePanelMode DYNfileSelector.dnResourceKitList.selectedItems.item[0].tag DYNfileSelectorFileType DYNfileSelectorSaveMode\n"
    LOCexe += "  )\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNedit    picked do (shelllaunch DYNfileSelector.dnFileList.selectedItems.item[0].tag \"\")\n"
    LOCexe += "  on MNDYNrefresh picked do (DYNfileSelector.DYNFUNsetFilePanelMode DYNfileSelector.dnResourceKitList.selectedItems.item[0].tag DYNfileSelectorFileType DYNfileSelectorSaveMode)\n"
    LOCexe += "  on MNDYNprops   picked do ()\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNdelete  picked do\n"
    LOCexe += "  (\n"
    LOCexe += "    if doesFileExist LOCselectedFile then\n"
    LOCexe += "    (\n"
    LOCexe += "      if not (getFileAttribute LOCselectedFile #readOnly) then\n"
    LOCexe += "      (\n"
    LOCexe += "        if querybox (DYNuiResourcesQueries[26] + \"\n\n\" + (filenamefrompath LOCselectedFile)) title:DYNuiResourcesTitlebars[2] then\n"
    LOCexe += "        (\n"
    LOCexe += "          local LOCrtnParam  = deleteFile LOCselectedFile\n"
    LOCexe += "          if not LOCrtnParam then\n"
    LOCexe += "          (\n"
    LOCexe += "            messagebox (DYNuiResourcesErrorsWarnings[38]) title:DYNuiResourcesTitlebars[2]\n"
    LOCexe += "          )\n"
    LOCexe += "          DYNfileSelector.DYNFUNsetFilePanelMode DYNfileSelector.dnResourceKitList.selectedItems.item[0].tag DYNfileSelectorFileType DYNfileSelectorSaveMode\n"
    LOCexe += "        )\n"
    LOCexe += "      )\n"
    LOCexe += "      else\n"
    LOCexe += "      (\n"
    LOCexe += "        messagebox (DYNuiResourcesErrorsWarnings[39]) title:DYNuiResourcesTitlebars[2]\n"
    LOCexe += "      )\n"
    LOCexe += "    )\n"
    LOCexe += "  )\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNrename picked do\n"
    LOCexe += "  (\n"
    LOCexe += "    local LOCnewFileName = DYNFUNdisplayEditText DYNuiResourcesTitlebars[28] DYNuiResourcesLabels[325] (FilenameFromPath LOCselectedFile)\n"
    LOCexe += "    if LOCnewFileName != undefined and LOCnewFileName != \"\" then\n"
    LOCexe += "    (\n"
    LOCexe += "      local LOCsuccess = DYNFUNrenameFile LOCselectedFile ((getFilenamePath LOCselectedFile) + LOCnewFileName) DYNfileSelectorFileType true\n"
    LOCexe += "      if LOCsuccess then DYNfileSelector.DYNFUNsetFilePanelMode DYNfileSelector.dnResourceKitList.selectedItems.item[0].tag DYNfileSelectorFileType DYNfileSelectorSaveMode\n"
    LOCexe += "    )\n"
    LOCexe += "  )\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNcopy    picked do\n"
    LOCexe += "  (\n"
    LOCexe += "    local LOCnewFileName = DYNFUNmakeNewFileNameUnique LOCselectedFile (getFilenameType LOCselectedFile)\n"
    LOCexe += "    LOCnewFileName = DYNFUNdisplayEditText DYNuiResourcesTitlebars[28] DYNuiResourcesLabels[325] (FilenameFromPath LOCnewFileName)\n"
    LOCexe += "    if LOCnewFileName != undefined and LOCnewFileName != \"\" then\n"
    LOCexe += "    (\n"
    LOCexe += "      local LOCsuccess = DYNFUNcopyFile LOCselectedFile ((getFilenamePath LOCselectedFile) + LOCnewFileName) DYNfileSelectorFileType true\n"
    LOCexe += "      if LOCsuccess then DYNfileSelector.DYNFUNsetFilePanelMode DYNfileSelector.dnResourceKitList.selectedItems.item[0].tag DYNfileSelectorFileType DYNfileSelectorSaveMode\n"
    LOCexe += "    )\n"
    LOCexe += "  )\n"
    LOCexe += ")\n"

    DYNfileSelector.LOCpopupMenu2 = Execute LOCexe

    registerRightClickMenu DYNfileSelector.LOCpopupMenu2
  )

  label          LBDYNfilePath     pos:[6,12]  width:90  height:13 align:#right
  editText       EDDYNfilePath  "" pos:[88,7]  width:350 height:22 enabled:false
  button         BUDYNdetails      pos:[443,7] width:26  height:22 iconName:"CivilView/Details"
  button         BUDYNimport       pos:[473,7] width:81  height:22

  dotNetControl  dnResourceKitList "System.Windows.Forms.ListView" pos:[5,35] width:80  height:340
  dotNetControl  dnFileList        "System.Windows.Forms.ListView" pos:[91,35] width:463 height:285

  label          LBDYNfileName     pos:[93,332]  width:80
  label          LBDYNfileType     pos:[93,358]  width:80

  editText       EDDYNfileName ""  pos:[196,329] width:248
  dropDownList   DDDYNfileType ""  pos:[200,355] width:245 height:21

  button         BUDYNokok         pos:[473,328] width:81  height:21
  button         BUDYNcanc         pos:[473,354] width:81  height:21
  button         BUDYNhelp         pos:[473,380] width:81  height:21

  on DYNfileSelector open do
  (
    BUDYNimport.text   = DYNuiResourcesButtons[62]

    LBDYNfilePath.text = DYNuiResourcesLabels[324]
    LBDYNfileName.text = DYNuiResourcesLabels[325]
    LBDYNfileType.text = DYNuiResourcesLabels[326]

    BUDYNokok.text     = DYNuiResourcesButtons[8]
    BUDYNcanc.text     = DYNuiResourcesButtons[3]
    BUDYNhelp.text     = DYNuiResourcesButtons[5]

    LOCresourceKitMode = DYNfileSelectorKitMode
    DYNFUNresourceKitListViewStyleAndContent DYNiconsPath LOCresourceKitMode DYNfileSelectorKitLock dnResourceKitList

    DYNFUNdnListViewStyle dnFileList false false
    dnFileList.multiSelect        = true
    dnFileList.AllowColumnReorder = true
    dnFileList.sorting            = DYNdnSortOrderClass.ascending
    dnFileList.largeImageList     = DYNdnLgImageList
    dnFileList.smallImageList     = DYNdnSmImageList
    local LOCcol1 = dnFileList.Columns.add DYNuiResourcesLvColumns[30] 170; LOCcol1.textAlign = DYNdnHorAlignClass.left
    local LOCcol2 = dnFileList.Columns.add DYNuiResourcesLvColumns[52]  60; LOCcol2.textAlign = DYNdnHorAlignClass.right
    local LOCcol3 = dnFileList.Columns.add DYNuiResourcesLvColumns[53]  80; LOCcol3.textAlign = DYNdnHorAlignClass.left
    local LOCcol4 = dnFileList.Columns.add DYNuiResourcesLvColumns[54] 120; LOCcol4.textAlign = DYNdnHorAlignClass.left

    DYNFUNlistMode DYNfileSelectorViewType
    DYNFUNresizeFileSelectorPanel (getDialogSize DYNfileSelector)

    DYNFUNsetFilePanelMode dnResourceKitList.Items.item[LOCresourceKitMode - 1].tag DYNfileSelectorFileType DYNfileSelectorSaveMode
    DYNFUNpopulateFileName DYNfileSelectorFileName
  )

  on DYNfileSelector resized argPt2 do
  (
    DYNFUNresizeFileSelectorPanel argPt2
  )

  on BUDYNdetails pressed do
  (
    DYNFUNmakePopUpMenu1()
    if DYNfileSelector.LOCpopupMenu1 != undefined then popupMenu DYNfileSelector.LOCpopupMenu1
  )

  on dnResourceKitList ItemSelectionChanged arg do
  (
    if arg.isSelected then
    (
      LOCresourceKitMode = DYNfileSelectorKitMode = arg.item.index + 1
      DYNFUNsetFilePanelMode arg.item.tag DYNfileSelectorFileType DYNfileSelectorSaveMode
    )
  )

  /*
  This is commented out, because this is called if edittext loses focus by user clicking on AX, and this causes unknown system exception
  on EDDYNfileName entered arg do
  (
    DYNFUNsaveOrOpenSelectedFile (LOCfileDir + (getfilenamefile arg) + "." + (DYNFUNlowerCase DYNfileSelectorFileType))
  )
  */

  on dnFileList ItemSelectionChanged arg do
  (
    if arg.isSelected then
    (
      EDDYNfileName.text = arg.item.text
    )
  )

  on dnFileList MouseUp arg do
  (
    if arg.button == DYNdnmouseClass.right then
    (
      DYNFUNmakePopUpMenu2()
      if DYNfileSelector.LOCpopupMenu2 != undefined then popupMenu DYNfileSelector.LOCpopupMenu2
    )
  )

  on dnFileList DoubleClick do
  (
    if dnFileList.selectedItems.count > 0 then
    (
      DYNFUNsaveOrOpenSelectedFile (dnFileList.selectedItems.item[0].tag)
    )
  )

  on dnFileList ColumnClick arg do
  (
    if dnFileList.sorting == DYNdnSortOrderClass.none       then
    (
      dnFileList.sorting = DYNdnSortOrderClass.ascending
    )
    else
    (
      if dnFileList.sorting == DYNdnSortOrderClass.ascending  then
      (
        dnFileList.sorting = DYNdnSortOrderClass.descending
      )
      else
      (
        if dnFileList.sorting == DYNdnSortOrderClass.descending then dnFileList.sorting = DYNdnSortOrderClass.ascending
      )
    )
    if dnFileList.selectedItems.count > 0 then dnFileList.selectedItems.item[0].ensureVisible()
  )


  on BUDYNokok pressed do
  (
    DYNFUNsaveOrOpenSelectedFile (LOCfileDir + (getfilenamefile EDDYNfileName.text) + "." + (DYNFUNlowerCase DYNfileSelectorFileType))
  )

  on BUDYNcanc pressed do
  (
    DYNfileSelector.LOCcurrentFile = undefined
    destroyDialog DYNfileSelector
  )

  on BUDYNimport pressed do
  (
    local LOCselectedFile = getOpenFileName caption:DYNuiResourcesTitlebars[27] filename:(LOCfileDir + "*." + (DYNFUNlowerCase DYNfileSelectorFileType)) types:(LOClongFileType + " (*." + (DYNFUNlowerCase DYNfileSelectorFileType) + ")|*." + (DYNFUNlowerCase DYNfileSelectorFileType) + "|")
    if LOCselectedFile != undefined and LOCselectedFile != "" then
    (
      local LOCsuccess = DYNFUNcopyFile LOCselectedFile (dnResourceKitList.selectedItems.item[0].tag + "\\" + DYNfileSelector.LOClongFileType + "\\" + (FilenameFromPath LOCselectedFile)) DYNfileSelectorFileType true
      if LOCsuccess then DYNfileSelector.DYNFUNsetFilePanelMode DYNfileSelector.dnResourceKitList.selectedItems.item[0].tag DYNfileSelectorFileType DYNfileSelectorSaveMode
    )
  )

  on BUDYNhelp pressed do DYNFUNopenHelp 13201 -- id_cv_civil_view_welcome
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQASeQX7hVyvtmhuXBi9okiIzsRX3zdAHEIG
-- CI6O5bur6DKwJVaDmF4NSj4RbXdShLWO7iqQsMZtyGfevZWkt22Sb3avkrbUvhn2
-- AKv5C7tvYB8dvkAs7CT2FyNQ/YnWYYfwvqXg19YT//1B9AG2mz9b0JhynLe/sp+v
-- Ir2PsFYJ/QS0hBD3b9l5rCRCXoPVgHwzF0zyxJkHglPk4pYZV3qOxQ3koNR19r0A
-- ZdSpPBeDDXHqNFe++en/pJtqawkedHc4/ZpfcZ7QD/Pn6y2kfCATnYMYuJ1FHLfJ
-- /AZhD8/geOTCcXiVekKa73Y/S6ZzCiXM+S3gQzo362R33u0V+vZf
-- -----END-SIGNATURE-----